{

    Copyright 2004 Marianne Wartoft, marianne at wartoft dot nu
    http://www.wartoft.nu, http://www.aw.nu

    This file is part of Sebran.

    Sebran is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Sebran is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Sebran; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

}


unit Hmeny;
{ This is the code for the main menu}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Hurman, Generell, memory,
  MPlayer, Hangman, Regn, About, IniFiles, registry, ShellAPI, Exit;

type
  TfrmHuvudmeny = class(TForm)
    Image1: TImage;
    shpOv1: TShape;
    lblOv1: TLabel;
    lblOv3: TLabel;
    shpOv2: TShape;
    shpOv4: TShape;
    shpOv3: TShape;
    lblOv4: TLabel;
    shpOv5: TShape;
    lblOv5: TLabel;
    shpAbout: TShape;
    lblOv8: TLabel;
    lblOv9: TLabel;
    shpOv8: TShape;
    shpOv10: TShape;
    shpOv9: TShape;
    lblOv10: TLabel;
    shpOv11: TShape;
    lblOv11: TLabel;
    Shape11: TShape;
    lblAbout: TLabel;
    shpOv12: TShape;
    lblOv12: TLabel;
    imgTest: TImage;
    imgOv1: TImage;
    imgOv2: TImage;
    imgOv3: TImage;
    imgOv4: TImage;
    imgOv5: TImage;
    imgOv8: TImage;
    imgOv9: TImage;
    imgOv10: TImage;
    imgOv11: TImage;
    imgOv12: TImage;
    shpOv6: TShape;
    lblOv6: TLabel;
    imgOv6: TImage;
    shpOv13: TShape;
    lblOv13: TLabel;
    shpExit: TShape;
    lblExit: TLabel;
    imgOv13: TImage;
    mplMIDI: TMediaPlayer;
    mplWAV1: TMediaPlayer;
    Shape2: TShape;
    imgSebran: TImage;
    lblReg1: TLabel;
    lblReg2: TLabel;
    shpHelp: TShape;
    lblOv2: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure lblOv1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv3MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv4MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv5MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv6MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblAboutMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv8MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv9MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv10MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv11MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv12MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv3MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv4MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv5MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImgOv6MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv8MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv9MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv10MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv11MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv12MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imgOv13MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblOv13MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblExitMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure mplMIDINotify(Sender: TObject);

    procedure imgSebranClick(Sender: TObject);

    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    MusicPosition: Integer;
  public
  end;

var
  frmHuvudmeny: TfrmHuvudmeny;

implementation

{$R *.DFM}

procedure TfrmHuvudmeny.FormShow(Sender: TObject);
var
   CurrFontSize: Integer;
begin

     FixForm(Self);
     RefFontSize := FontSize(Height div 10, 'Arial', imgTest.Canvas);
     ButtonFontSize := FontSize(Height div 30, 'Arial', imgTest.Canvas);

     SetPalette(imgOv1);
     SetPalette(imgOv2);
     SetPalette(imgOv3);
     SetPalette(imgOv4);
     SetPalette(imgOv5); 
     SetPalette(imgOv6);
     SetPalette(imgOv8);
     SetPalette(imgOv9);
     SetPalette(imgOv10);
     SetPalette(imgOv11);
     SetPalette(imgOv12);
     SetPalette(imgOv13);

     CurrFontSize := Trunc(RefFontSize * 1.3);

     {Draw pictures on the buttons in the main menu}
     DrawChar(0, 0, imgOv1, Chr(Pics[46].ASCII), Pics[46].Color, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv2, Chr(Pics[2].ASCII), Pics[2].Color, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv3, Chr(Pics[2].ASCII), $FF8020, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv4, Chr(Pics[2].ASCII), $20FFFF, SYMBOLTYPEFACE, CurrFontSize);

     DrawChar(0, 0, imgOv5, Chr(Pics[13].ASCII), Pics[13].Color, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv6, Chr(Pics[1].ASCII), Pics[1].Color, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv8, Chr(Pics[4].ASCII), Pics[4].Color, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv9, Chr(Pics[6].ASCII), $FF00F0, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv10, Chr(Pics[5].ASCII), $90FF90, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv11, Chr(Pics[5].ASCII), Pics[5].Color, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv12, Chr(Pics[6].ASCII), $FF3080, SYMBOLTYPEFACE, CurrFontSize);
     DrawChar(0, 0, imgOv13, Chr(Pics[6].ASCII), $FFD030, SYMBOLTYPEFACE, CurrFontSize);
     if not IsPreRegistered then begin
        lblOv2.Font.Color := clGray;
        lblOv3.Font.Color := clGray;
        lblOv4.Font.Color := clGray;
        lblOv5.Font.Color := clGray;
        lblOv6.Font.Color := clGray;
        lblOv8.Font.Color := clGray;
        lblOv9.Font.Color := clGray;
        lblOv11.Font.Color := clGray;
        lblOv12.Font.Color := clGray;
        lblOv13.Font.Color := clGray;
     end else begin
         lblReg1.Visible := False;
         lblReg2.Visible := False;
     end;
end;

procedure TfrmHuvudmeny.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
   SelShape: TShape;
   i: Integer;
begin
     { Check which shape was clicked (if any) and take the
       corresponding action }
     Enabled := False;
     SelShape := Nil;
     For i := 0 to ComponentCount-1 do begin
         if Components[i] is TShape then begin
            if ((X > TShape(Components[i]).Left)) and (X < (TShape(Components[i]).Left + TShape(Components[i]).Width)) and
            (Y > TShape(Components[i]).Top) and (Y < (TShape(Components[i]).Top) + TShape(Components[i]).Height) then begin
               SelShape := TShape(Components[i])
             end;
         end;
     end;

     if SelShape <> Nil Then begin
        PlaySound('KLICK3.WAV', 1);
     end;
     if not IsPreregistered and (SelShape.Tag <>1)  then begin
        MessageDlg(Concat(strLang[28] , ' ' , strLang[29]), mtInformation, [mbOK],0);
     end else begin
     If SelShape = shpOv1 then begin
        frmOvMC := TfrmOvMC.Create(Self);
        frmOvMC.Start(HURMANGA);
     end;
     If SelShape = shpOv2 then begin
        frmOvMC := TfrmOvMC.Create(Self);
        frmOvMC.Start(ADDITION);
     end;
     If SelShape = shpOv3 then begin
        frmOvMC := TfrmOvMC.Create(Self);
        frmOvMC.Start(SUBTRAKTION);
     end;
     If SelShape = shpOv4 then begin
        frmOvMC := TfrmOvMC.Create(Self);
        frmOvMC.Start(MULTIPLIKATION);
     end;
     If SelShape = shpOv10 then begin
       frmOvMemory := TfrmOvMemory.Create(Self);
       frmOvMemory.Start(MEMORYY);
     end;
     If SelShape = shpOv5 then begin
        frmOvMC := TfrmOvMC.Create(Self);
        frmOvMC.Start(RATTBILD);
     end;
     If SelShape = shpOv6 then begin
        frmOvMC := TfrmOvMC.Create(Self);
        frmOvMC.Start(FORSTABOKST);
     end;
     If SelShape = shpOv11 then begin
        frmOvMemory := TfrmOvMemory.Create(Self);
        frmOvMemory.Start(ORDMEMORY);
     end;
     If SelShape = shpOv12 then begin
        frmOvRegn := TfrmOvRegn.Create(Self);
        frmOvRegn.Start(BOKSTAVSREGN);
     end;
     If SelShape = shpOv9 then begin
        frmOvRegn := TfrmOvRegn.Create(Self);
        frmOvRegn.Start(ALFABETSREGN);
     end;
     If SelShape = shpOv13 then begin
        frmOvRegn := TfrmOvRegn.Create(Self);
        frmOvRegn.Start(MATTEREGN);
     end;
     If SelShape = shpOv8 then begin
        frmOvHangman := TfrmOvHangman.Create(Self);
        frmOvHangman.Start;
     end;
     end;
     If SelShape = shpAbout then begin
        frmAbout.ShowModal;
        ShowLang(Self);
     end;
     If SelShape = shpExit then begin
        StopSong;
        frmExit := TfrmExit.Create(Self);

        Self.visible := false;
        frmExit.ShowModal;
        Close;
     end;

     Enabled := True;
end;

procedure TfrmHuvudmeny.FormCreate(Sender: TObject);
var
   IniFile: TRegIniFile;

begin
     intBitsPerPixel := getdevicecaps(GetDC(0), BITSPIXEL);
     TYPEFACE := 'Sebran3';
     SYMBOLTYPEFACE := 'Sebran Symbols';


     {Check that the special fonts are installed}

     If (Screen.Fonts.IndexOf(TYPEFACE) = -1) or (Screen.Fonts.IndexOf(SYMBOLTYPEFACE) = -1) then begin
        messagedlg(Concat ('The fonts that are necessary to run this program are not installed.',
                          'To function properly, the program must be installed again'),
                   mtInformation, [mbOK],0);
     end;

     Spraknamn[1]:='Swedish';
     Spraknamn[2]:='English';
     Spraknamn[3]:='Danish';
     Spraknamn[4]:='Norwegian';
     Spraknamn[5]:='Finnish';
     Spraknamn[6]:='German';
     Spraknamn[7]:='Croatian';
     Spraknamn[8]:='Estonian';
     Spraknamn[9]:='French';
     Spraknamn[10]:='Catalan';
     Spraknamn[11]:='Spanish (Spain)';
     Spraknamn[12]:='Spanish (Latin America)';
     Spraknamn[13]:='Romanian';
     Spraknamn[14]:='Afrikaans';
     Spraknamn[15]:='Breton';
     Spraknamn[16]:='Polish';
     Spraknamn[17]:='Italian';
     Spraknamn[18]:='Portuguese (Brazil)';
     Spraknamn[19]:='Icelandic';
     Spraknamn[20]:='Greek';
     Spraknamn[21]:='Turkish';
     Spraknamn[22]:='Dutch';
     Spraknamn[23]:='Bahasa Indonesian';
     Spraknamn[24]:='Czech';
     Spraknamn[25]:='Samoan';
     Spraknamn[26]:='Slovak';
     Spraknamn[27]:='Hungarian';
     Spraknamn[28]:='Lithuanian';
     Spraknamn[29]:='Norwegian (Nynorsk)';
     Spraknamn[30]:='Slovenian';
     Spraknamn[31]:='Swahili';
     Spraknamn[32]:='Esperanto';

     {Get settings from the INI-file}
     IniFile:=TRegIniFile.Create('Software\Sebran');
     Sprak := IniFile.ReadInteger('Options','Language',2);
     if (Sprak < 1) or (Sprak > AntalSprak) then Sprak := 2;
     intRainSpeed := IniFile.ReadInteger('Options','RainSpeed',1);
     fPlaySongs := (IniFile.ReadInteger('Options','Music',1) = 1);
     fPlaySounds := (IniFile.ReadInteger('Options','Sounds',1) = 1);
     intCapital := IniFile.ReadInteger('Options','Capital',0);
     { Read in a bitmap just to get its palette. }
     Bitmap := TBitmap.Create;
     Bitmap.LoadFromFile( Concat(AppPath, '\bmptest.bmp') );
     { Read in language-specific arrays }
     GetLang;
     ReadPicFile;
     MusicPosition := 0;
end;

procedure TfrmHuvudmeny.lblOv1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv1.Left, Y + lblOv1.Top);

end;

procedure TfrmHuvudmeny.lblOv2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv2.Left, Y + lblOv2.Top);

end;

procedure TfrmHuvudmeny.lblOv3MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv3.Left, Y + lblOv3.Top);

end;

procedure TfrmHuvudmeny.lblOv4MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv4.Left, Y + lblOv4.Top);

end;

procedure TfrmHuvudmeny.lblOv5MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv5.Left, Y + lblOv5.Top);

end;

procedure TfrmHuvudmeny.lblOv6MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv6.Left, Y + lblOv6.Top);

end;

procedure TfrmHuvudmeny.lblAboutMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblAbout.Left, Y + lblAbout.Top);

end;

procedure TfrmHuvudmeny.lblOv8MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv8.Left, Y + lblOv8.Top);

end;

procedure TfrmHuvudmeny.lblOv9MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv9.Left, Y + lblOv9.Top);

end;

procedure TfrmHuvudmeny.lblOv10MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv10.Left, Y + lblOv10.Top);

end;

procedure TfrmHuvudmeny.lblOv11MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv11.Left, Y + lblOv11.Top);

end;

procedure TfrmHuvudmeny.lblOv12MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + lblOv12.Left, Y + lblOv12.Top);

end;

procedure TfrmHuvudmeny.imgOv1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv1.Left, Y + imgOv1.Top);

end;

procedure TfrmHuvudmeny.imgOv2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv2.Left, Y + imgOv2.Top);

end;

procedure TfrmHuvudmeny.imgOv3MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv3.Left, Y + imgOv3.Top);

end;

procedure TfrmHuvudmeny.imgOv4MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv4.Left, Y + imgOv4.Top);

end;

procedure TfrmHuvudmeny.imgOv5MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv5.Left, Y + imgOv5.Top);

end;

procedure TfrmHuvudmeny.ImgOv6MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv6.Left, Y + imgOv6.Top);

end;


procedure TfrmHuvudmeny.imgOv8MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv8.Left, Y + imgOv8.Top);

end;

procedure TfrmHuvudmeny.imgOv9MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv9.Left, Y + imgOv9.Top);

end;

procedure TfrmHuvudmeny.imgOv10MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv10.Left, Y + imgOv10.Top);

end;

procedure TfrmHuvudmeny.imgOv11MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv11.Left, Y + imgOv11.Top);

end;

procedure TfrmHuvudmeny.imgOv12MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv12.Left, Y + imgOv12.Top);

end;

procedure TfrmHuvudmeny.imgOv13MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     FormMouseDown(Sender, Button, Shift, X + imgOv13.Left, Y + imgOv13.Top);

end;

procedure TfrmHuvudmeny.lblOv13MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    FormMouseDown(Sender, Button, Shift, X + lblOv13.Left, Y + lblOv13.Top);

end;

procedure TfrmHuvudmeny.lblExitMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    FormMouseDown(Sender, Button, Shift, X + lblExit.Left, Y + lblExit.Top);

end;


procedure TfrmHuvudmeny.FormActivate(Sender: TObject);
begin

     ShowLang(Self);
     PlaySong('DIDELI.MID', MusicPosition, True);
end;

procedure TfrmHuvudmeny.FormDeactivate(Sender: TObject);
begin
     MusicPosition := SongPosition;
end;


procedure TfrmHuvudmeny.mplMIDINotify(Sender: TObject);
begin
     { This code makes sure the music will loop if the
       PlaySong function was called with the argument Rep
       set to true.}
     if (mplMIDI.Mode <> mpPlaying) and fRepeatSong then begin
        mplMIDI.Notify := False;
        mplMIDI.Rewind;
        mplMIDI.Notify := True;
        mplMIDI.Play;
     end
end;


procedure TfrmHuvudmeny.imgSebranClick(Sender: TObject);
begin
     PlaySound('Gnaegg1.Wav', 1);
end;




procedure TfrmHuvudmeny.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If key=112 then begin
          ShowHelp(Handle);
     end;
end;



end.
