{

    Copyright 2004 Marianne Wartoft, marianne at wartoft dot nu
    http://www.wartoft.nu, http://www.aw.nu

    This file is part of Sebran.

    Sebran is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Sebran is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Sebran; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

}


unit About;
{ This is the code for the About / Settings form}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Generell, IniFiles, ShellAPI, registry;

type
  TfrmAbout = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    imgExit: TImage;
    Label3: TLabel;
    Label4: TLabel;
    chkMusic: TCheckBox;
    chkSound: TCheckBox;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Label9: TLabel;
    cboLanguage: TComboBox;
    Label7: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    lblWeb: TLabel;
    imgWebSite: TImage;
    Label5: TLabel;
    grpCapital: TRadioGroup;
    Label16: TLabel;
    grpSpeed: TRadioGroup;
    Shape4: TShape;
    Label6: TLabel;
    lblEducationalFreeware: TLabel;
    lblBestFreeware: TLabel;
    procedure FormShow(Sender: TObject);
    procedure imgExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure imgWebSiteClick(Sender: TObject);

    procedure EnableDisableCapitals(Sender: TObject);
    procedure cboLanguageChange(Sender: TObject);
    procedure lblWebClick(Sender: TObject);
    procedure lblEducationalFreewareClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private
  public
    { Public declarations }
  end;

var
  frmAbout: TfrmAbout;

implementation

uses Hmeny;

{$R *.DFM}

procedure TfrmAbout.FormShow(Sender: TObject);
begin
     Color := clBlack;
     DrawButton(imgExit, 'OK', clWhite, 'Arial', 12, 30, THINBORDER);
     DrawButton(imgWebSite, 'Visit Web Site', clWhite, 'Arial', 12, 30, THINBORDER);
end;

procedure TfrmAbout.imgExitClick(Sender: TObject);
var
   IniFile: TRegIniFile ;
   CurrSprak: Integer;
   i: Integer;

begin
     {If the language has been changed, update the
      language arrays}
      For i:=1 to AntalSprak do begin
         if Spraknamn[i]=cboLanguage.Items[cboLanguage.ItemIndex] then CurrSprak:=i;
     end;
     if Sprak <> CurrSprak then begin
        Sprak := CurrSprak;
        ReadPicFile;
        GetLang;
     end;
     if (chkMusic.Checked = false) and fPlaySongs then begin
        StopSong;
        fPlaySongs := false;

     end;
     if (chkMusic.Checked = true) and (fPlaySongs = false) then begin
        fPlaySongs := true;
        PlaySong('DIDELI.MID', 0, True);

     end;
     fPlaySounds := chkSound.Checked ;
     intCapital := grpCapital.itemindex ;
     intRainSpeed := grpSpeed.ItemIndex + 1;

     PlaySound('Klick1.WAV', 1);

     {Save the settings to the Sebran INI-file}
     Try
        IniFile := TRegIniFile.Create('Software\Sebran');
        IniFile.WriteString('Options','Language',intToStr(Sprak));
        IniFile.WriteString('Options','RainSpeed',intToStr(intRainSpeed));
        if fPlaySongs then
           IniFile.WriteString('Options','Music', '1')
        else
           IniFile.WriteString('Options','Music', '0');
        if fPlaySounds then
           IniFile.WriteString('Options','Sounds', '1')
        else
            IniFile.WriteString('Options','Sounds', '0');

        IniFile.WriteString('Options','Capital', intToStr(intCapital))

     except
           Messagedlg('Could not write to Sebran.ini-file',mtInformation,[mbOK],0);
     end;
     Close;
end;

procedure TfrmAbout.FormCreate(Sender: TObject);
var
   i: Integer;
begin
     For i:=1 to AntalSprak do begin
         cboLanguage.Items.Add(SprakNamn[i]);
     end;
end;

procedure TfrmAbout.FormActivate(Sender: TObject);
var
   i: Integer;
begin
     For i:=0 to cboLanguage.Items.Count do begin
         if cboLanguage.Items[i]=Spraknamn[Sprak] then cboLanguage.ItemIndex:=i;
     end;
     EnableDisableCapitals(Sender);
     chkMusic.Checked := fPlaySongs;
     chkSound.Checked := fPlaySounds;

     grpCapital.itemindex := intCapital;
     grpSpeed.itemindex := intRainSpeed - 1;

end;



procedure TfrmAbout.imgWebSiteClick(Sender: TObject);
var
   MyStr: Array[0..255] of char;
   strFileName: String;
begin
   try
      if Sprak <> 1 then
         strFileName := Concat('http://www.wartoft.nu/software/?from=Sebran&lang=',IntToStr(Sprak))
      else
         strFileName := Concat('http://www.wartoft.nu/program/?from=Sebran&lang=1');

      StrPCopy(MyStr, strFileName);
      ShellExecute(Handle, Nil, MyStr, Nil, Nil, SW_RESTORE);

   finally
   end;

end;


procedure TfrmAbout.EnableDisableCapitals(Sender: TObject);
begin
          if cboLanguage.Text = 'Greek' then begin  {  'Greek      }
             grpCapital.Enabled := False;
             grpCapital.ItemIndex := 0;
          end else
             grpCapital.Enabled := True;






end;


procedure TfrmAbout.cboLanguageChange(Sender: TObject);
begin
     EnableDisableCapitals(Sender);
end;

procedure TfrmAbout.lblWebClick(Sender: TObject);
begin
     imgWebSiteClick(lblWeb);
end;

procedure TfrmAbout.lblEducationalFreewareClick(Sender: TObject);
var
   MyStr: Array[0..255] of char;
   strFileName: String;
begin
   try

      strFileName := 'http://www.best-freeware.com';

      StrPCopy(MyStr, strFileName);
      ShellExecute(Handle, Nil, MyStr, Nil, Nil, SW_RESTORE);

   finally
   end;
end;

procedure TfrmAbout.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If key=112 then begin
          ShowHelp(Handle);
     end;
end;

end.
