{

    Copyright 2004 Marianne Wartoft, marianne at wartoft dot nu
    http://www.wartoft.nu, http://www.aw.nu

    This file is part of Sebran.

    Sebran is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Sebran is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Sebran; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

}


unit Hurman;
{ The code for the mulitple choice exercises:
  How Many? Addition, Subtraction, Multiplication, Pick a Picture and
  First Letter }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Generell, StdCtrls, Buttons, Message, MPlayer;

type
  TfrmOvMC = class(TForm)
    Image1: TImage;
    lblRubrik: TLabel;
    Image2: TImage;
    imgSvar1: TImage;
    imgSvar2: TImage;
    imgSvar3: TImage;
    imgSvar4: TImage;
    tmrNew: TTimer;
    imgSvar5: TImage;
    imgSvar6: TImage;
    imgSvar7: TImage;
    imgSvar8: TImage;
    imgBild2: TImage;
    imgHard: TImage;
    imgEasy: TImage;
    imgHelp: TImage;
    imgExit: TImage;
    imgBild1: TImage;
    procedure imgDummyClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure imgSvar1Click(Sender: TObject);
    procedure imgSvar2Click(Sender: TObject);
    procedure imgSvar3Click(Sender: TObject);
    procedure imgSvar4Click(Sender: TObject);
    procedure tmrNewTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure imgExitClick(Sender: TObject);
    procedure imgEasyClick(Sender: TObject);
    procedure imgHardClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure imgHelpClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
private
    procedure StartExercise;
    procedure PlacePictures;
    procedure ClearPictures;
    procedure DrawDifficultyButtons;
  public
    procedure Start (ExTyp: Integer);
  end;

Const
     MaxNrOfPictures = 9;

var
  frmOvMC: TfrmOvMC;

implementation

{$R *.DFM}

uses
    Hmeny;
var
   Alt: Array[1..4] of Integer;
   AltString: Array[1..4] of String;
   AltColor: Array[1..4] of LongInt;
   CorrAnswer: Integer;
   CurrFontSize: Integer;
   FaceFontSize: Integer;
   CMaxNrOfPictures: Integer;
   WholeString: String;
   NrOfPictures, CurrPicture, PictureSize: Integer;
   CurrCol: Longint;
   Positions: Array[1..MaxNrOfPictures] of Posi;
   ExerciseType: Integer;
   Im1, Im2, Im3, Im4: TImage;
   Easy: Boolean;
   ShowDiffiButtons: Boolean;
   OldNrOfPictures, OldPicture, OldTal1, OldTal2: Integer;
   Tal1, Tal2: Integer;

procedure TfrmOvMC.Start(ExTyp: Integer);
{ This code is run when the form is opened}
begin
     SetPalette(imgBild1);
    SetPalette(imgBild2);

     ExerciseType := ExTyp;
     case ExerciseType of
       ADDITION: begin
          lblRubrik.Caption := Concat('~~~~~   ', strLang[2], '   ~~~~~');
          ShowDiffiButtons := True;
          DrawButton(imgBild1, Chr(Pics[2].ASCII), Pics[2].Color, SYMBOLTYPEFACE, RefFontSize * 2  , -1, NOBORDER);
       end;
       SUBTRAKTION: begin
          lblRubrik.Caption := Concat('~~~~~   ', strLang[3], '   ~~~~~');
          ShowDiffiButtons := True;
          DrawButton(imgBild1, Chr(Pics[2].ASCII), $FF8020, SYMBOLTYPEFACE, RefFontSize * 2  , -1, NOBORDER);
       end;
       MULTIPLIKATION: begin
          lblRubrik.Caption := Concat('~~~~~   ', strLang[4], '   ~~~~~');
          ShowDiffiButtons := True;
          DrawButton(imgBild1, Chr(Pics[2].ASCII), $20FFFF, SYMBOLTYPEFACE, RefFontSize * 2  , -1, NOBORDER);
       end;
       HURMANGA: begin
          CMaxNrOfPictures :=  MaxNrOfPictures;
          lblRubrik.Caption := '';
          ShowDiffiButtons := False;
       end;
       FORSTABOKST, RATTBILD: begin
          lblRubrik.Caption := '~~~~~~~~~~~~~~~~~~~~';
          ShowDiffiButtons := False;
       end;
     end;
     { Arragnge, hide and display the images correctly}
     case ExerciseType of
       RATTBILD, ADDITION, SUBTRAKTION, MULTIPLIKATION: begin
          im1:= imgSvar5;
          im2:= imgSvar6;
          im3:= imgSvar7;
          im4:= imgSvar8;
          imgSvar1.Visible := False;
          imgSvar2.Visible := False;
          imgSvar3.Visible := False;
          imgSvar4.Visible := False;
          imgSvar5.Visible := True;
          imgSvar6.Visible := True;
          imgSvar7.Visible := True;
          imgSvar8.Visible := True;
          FaceFontSize := RefFontSize * 3;
          imgBild1.Visible := True;
       end;
       else begin
          im1:= imgSvar1;
          im2:= imgSvar2;
          im3:= imgSvar3;
          im4:= imgSvar4;
          imgSvar1.Visible := True;
          imgSvar2.Visible := True;
          imgSvar3.Visible := True;
          imgSvar4.Visible := True;
          imgSvar5.Visible := False;
          imgSvar6.Visible := False;
          imgSvar7.Visible := False;
          imgSvar8.Visible := False;
          FaceFontSize := RefFontSize * 2;
          imgBild1.Visible := False;
      end;
     end;
     Image1.Height := Im1.Top - Image1.Top - 2;
     Easy := True;
     DrawDifficultyButtons;
     Show;
     StartExercise;

end;


procedure TfrmOvMC.StartExercise;
var
   r,g,b: Longint;
   i: integer;
   FontName: String;
   TalTemp: Integer;
   QueryString: String;
   X,Y: Integer;
   PrintString: String;
   MaxTal, MinTal: Integer;
begin
     Randomize;
     ClearPictures;

     Case ExerciseType of
     HURMANGA: begin
       {Select how many objects to display, set size and positions}
       OldNrOfPictures := NrOfPictures;
       repeat
             NrOfPictures := Trunc(Random * CMaxNrOfPictures) + 1;
       until NrOfPictures <> OldNrOfPictures;
       OldPicture := CurrPicture;
       Repeat
         CurrPicture :=  Trunc(Random * NrOfPics) + 1;
       Until (Pics[CurrPicture].Plural <> '') and (CurrPicture <> OldPicture);
       PictureSize := trunc(Image1.Height / 1.5) - NrOfPictures * (Image1.Height div 35);
       PlacePictures;

       {Draw the pictures}
       CurrCol := Pics[CurrPicture].Color;
       lblRubrik.Caption := CorrCase(Concat('~ ', strLang[16], ' ', Pics[CurrPicture].Plural, ' ' ,  strLang[14] ,' ~'));

       For i:=1 to NrOfPictures do begin
           DrawChar(Positions[i].X, Positions[i].Y, Image1, Chr(Pics[CurrPicture].ASCII), CurrCol,
                    SYMBOLTYPEFACE, PictureSize);
       end;

       {Draw the alternatives}
       Application.ProcessMessages;
       GetAlts(Alt, 4, NrOfPictures, 1, CMaxNrOfPictures+1);
       {Correct answer}
       CorrAnswer := Trunc(4 * Random) + 1;
       Alt[CorrAnswer] := NrOfPictures;
       For i:=1 to 4 do begin
           AltString[i] := IntToStr(Alt[i]);
           AltColor[i] := clWhite;
       end;
       CurrFontSize := Trunc(RefFontSize * 1.3);
       FontName := TYPEFACE;
     end;
     ADDITION, SUBTRAKTION, MULTIPLIKATION: begin
       If Easy then MaxTal := 6 else MaxTal := 12;
       If Easy then MinTal := 1 else MinTal := 5;
       OldTal1 := Tal1;
       OldTal2 := Tal2;
       repeat
             Tal1 := Trunc(Random * (MaxTal-MinTal)) + MinTal;
             Tal2 := Trunc(Random * (MaxTal-MinTal)) + MinTal;
       until (Tal1<> OldTal1) and (Tal2 <> OldTal2);
       CurrFontSize := Trunc(RefFontSize * 1.3);
       CorrAnswer := Trunc(4 * Random) + 1;
       case ExerciseType of
       ADDITION: begin
          QueryString := Concat(IntToStr(Tal1), ' + ' ,IntToStr(Tal2));
          GetAlts(Alt, 4, Tal1 + Tal2, 1, MaxTal * 2);
          Alt[CorrAnswer] := Tal1 + Tal2;
       end;
       SUBTRAKTION: begin
          If Tal1 < Tal2 then begin
             TalTemp := Tal1;
             Tal1 := Tal2;
             Tal2 := TalTemp;
          end;
          QueryString := Concat(IntToStr(Tal1), ' - ' ,IntToStr(Tal2));
          GetAlts(Alt, 4, Tal1 - Tal2, 1, MaxTal);
          Alt[CorrAnswer] := Tal1 - Tal2;
       end;
       MULTIPLIKATION: begin
          QueryString := Concat(IntToStr(Tal1), '  ' ,IntToStr(Tal2));
          GetAlts(Alt, 4, Tal1 * Tal2, 1, MaxTal * MaxTal);
          Alt[CorrAnswer] := Tal1 * Tal2;
       end;
       end;
       Y := Trunc(Image1.Height * 0.5);
       X := (Image1.Width ) div 2;
       DrawCharCenter(X, Y, Image1, QueryString, $70FFFF, TYPEFACE, Trunc(RefFontSize * 1.5));

       X := (Image1.Width ) div 2;
       Y := (Image1.Height ) div 4;
       For i:=1 to 4 do begin
           AltString[i] := IntToStr(Alt[i]);
           AltColor[i] := clWhite;
       end;
       FontName := TYPEFACE;
     end;
     RATTBILD: begin
       OldPicture := CurrPicture;
       Repeat
         CurrPicture :=  Trunc(Random * NrOfPics) + 1;
       Until (Pics[CurrPicture].Singular <> '') and (CurrPicture <> OldPicture);
       GetAlts(Alt, 4, CurrPicture, 1, NrOfPics);
       {Correct answer}
       CorrAnswer := Trunc(4 * Random) + 1;
       Alt[CorrAnswer] := CurrPicture;

       Y := Trunc(Image1.Height * 0.4 );
       X := (Image1.Width ) div 2;
       DrawCharCenter(X, Y, Image1, CorrCase(Pics[CurrPicture].Singular), clWhite, TYPEFACE, Trunc(RefFontSize * 1.3));
       For i:=1 to 4 do begin
           AltString[i] := Chr(Pics[Alt[i]].ASCII);
           AltColor[i] := Pics[Alt[i]].Color;
       end;

       CurrFontSize := Trunc(RefFontSize * 3.5);
       FontName := SYMBOLTYPEFACE;
     end;
     FORSTABOKST: begin
       OldPicture := CurrPicture;
       Repeat
         CurrPicture :=  Trunc(Random * NrOfPics) + 1;
       Until (Pics[CurrPicture].Singular <> '') and (CurrPicture <> OldPicture) and (Pos(AnsiUppercase(Pics[CurrPicture].Singular[1]), strLang[21]) > 0) ;
       GetAlts(Alt, 4, Pos(AnsiUppercase(Pics[CurrPicture].Singular[1]), strLang[21]), 1, Length(strLang[21]));
       {Correct answer}
       CorrAnswer := Trunc(4 * Random) + 1;
       Alt[CorrAnswer] := Pos(AnsiUppercase(Pics[CurrPicture].Singular[1]), strLang[21]);

       Y :=  Trunc(Image1.Height * 0.3);
       X := (Image1.Width) div 2;
       DrawCharCenter(X, Y, Image1, Chr(Pics[CurrPicture].ASCII),
                         Pics[CurrPicture].Color, SYMBOLTYPEFACE, Trunc(RefFontSize * 5));

       PrintString := CorrCase(Pics[CurrPicture].Singular);
       If intCapital = 0 then PrintString[1] := AnsiUppercase(PrintString)[1];
       WholeString := PrintString;
       PrintString[1] := '-';

       Image1.Canvas.Font.Name := TYPEFACE;
       Image1.Canvas.Font.Size := Trunc(RefFontSize * 1.5);
       Image1.Canvas.Font.Style := [];
       Y := Trunc(Image1.Height * 0.8) - Image1.Canvas.TextHeight(WholeString) div 2;
       X := (Image1.Width) div 2 - Image1.Canvas.TextWidth(WholeString) div 2;
       X := X - (Image1.Canvas.TextWidth(PrintString[1]) - Image1.Canvas.TextWidth(WholeString[1]));
       DrawChar(X, Y, Image1, PrintString, clWhite, TYPEFACE, Trunc(RefFontSize * 1.5));

       For i:=1 to 4 do begin
           AltString[i] := CorrCase(strLang[21][Alt[i]]);
           AltColor[i] := clWhite;
       end;

       CurrFontSize := Trunc(RefFontSize * 1.5);
       FontName := TYPEFACE;

     end;

     end;
     DrawButton(Im1, AltString[1], AltColor[1], FontName, CurrFontSize , 90, THICKBORDER);
     DrawButton(Im2, AltString[2], AltColor[2], FontName, CurrFontSize , 90, THICKBORDER);
     DrawButton(Im3, AltString[3], AltColor[3], FontName, CurrFontSize , 90, THICKBORDER);
     DrawButton(Im4, AltString[4], AltColor[4], FontName, CurrFontSize , 90, THICKBORDER);

end;

procedure TfrmOvMC.PlacePictures;
var
   i , j, loops: Longint;
   Collide: Boolean;
   Frame : Integer;
begin
     loops := 0;
     Frame := Image1.Height div 4;
     For i := 1 to NrOfPictures do begin
           Positions[i].X := Trunc(Random * (Image1.Width - PictureSize - Frame)) + Frame div 2 ;
           Positions[i].Y := Trunc(Random * (Image1.Height - PictureSize - Frame)) + Frame div 2 ;
    end;
    repeat
       Collide := False;
       loops := loops + 1;
       For i := 1 to NrOfPictures do begin
           For j:=1 to NrOfPictures do begin

              If (abs(Positions[i].X - Positions[j].X) < (PictureSize * 0.9) ) and
                 (abs(Positions[i].Y - Positions[j].Y) < (PictureSize * 0.9) ) and
                 (i <> j) then begin
                      Positions[i].X := Trunc(Random * (Image1.Width - PictureSize - Frame)) + Frame div 2 ;
                      Positions[i].Y := Trunc(Random * (Image1.Height - PictureSize - Frame)) + Frame div 2 ;
                      Collide := True;
                      Break;
              end;
           end;
       end;
       If (Loops / 100) = trunc(Loops / 100) then PictureSize := Trunc(PictureSize * 0.9);
     until (collide = False) or (loops = 14000);
end;


procedure TfrmOvMC.ClearPictures;
var
   i: integer;
begin
     Image1.Canvas.Brush.Color := clBlack;
     Image1.Canvas.Brush.Style := bsSolid;
     Image1.Canvas.FillRect( Rect( 0 ,0, Image1.Width, Image1.Height ) );
end;

procedure TfrmOvMC.imgDummyClick(Sender: TObject);
begin
     ShowMessage('Tjo fljt i lingonskogen...', 'Ja', 'Nej');
     StartExercise;

end;

procedure TfrmOvMC.FormCreate(Sender: TObject);
begin
     FixForm(Self);
     lblRubrik.Font.Name := TYPEFACE;
end;

procedure CorrectAnswer(img: TImage; Ans: Integer);
var
   X ,Y: Integer;
begin
     If Ans = CorrAnswer then begin
         PlaySound('DROPP1.WAV', 2);
         DrawButton(img, chr(HAPPYFACE), clGreen, SYMBOLTYPEFACE, FaceFontSize , 90, THICKBORDER);
         frmOvMC.tmrNew.Enabled := True;
         case ExerciseType of
         FORSTABOKST: begin
           frmOvMC.ClearPictures;
           Y :=  Trunc(frmOvMC.Image1.Height * 0.3);
           X := (frmOvMC.Image1.Width) div 2;
           DrawCharCenter(X, Y, frmOvMC.Image1, Chr(Pics[CurrPicture].ASCII),
                         Pics[CurrPicture].Color, SYMBOLTYPEFACE, Trunc(RefFontSize * 5));
           Y := Trunc(frmOvMC.Image1.Height * 0.8);
           X := (frmOvMC.Image1.Width) div 2;
           DrawCharCenter(X, Y, frmOvMC.Image1, WholeString, clWhite, TYPEFACE, Trunc(RefFontSize * 1.5));
         end;
     end;
     end else begin
         PlaySound('BRUPP1.WAV', 2);
         DrawButton(img, chr(SADFACE), clRed, SYMBOLTYPEFACE, FaceFontSize , 90, THICKBORDER);
     end;
end;


procedure TfrmOvMC.imgSvar1Click(Sender: TObject);
begin
     CorrectAnswer(Sender as TImage, 1);
end;

procedure TfrmOvMC.imgSvar2Click(Sender: TObject);
begin
     CorrectAnswer(Sender as TImage, 2);
end;

procedure TfrmOvMC.imgSvar3Click(Sender: TObject);
begin
     CorrectAnswer(Sender as TImage, 3);
end;

procedure TfrmOvMC.imgSvar4Click(Sender: TObject);
begin
     CorrectAnswer(Sender as TImage, 4);
end;

procedure TfrmOvMC.tmrNewTimer(Sender: TObject);
begin
     tmrNew.Enabled := False;
     StartExercise;
end;

procedure TfrmOvMC.FormShow(Sender: TObject);
begin
     StopSong;
     SetPalette(Image1);
     SetPalette(Im1);
     SetPalette(Im2);
     SetPalette(Im3);
     SetPalette(Im4);
     DrawButton(imgHelp, strLang[14], clWhite, TYPEFACE, ButtonFontSize, 30, THINBORDER);
     DrawButton(imgExit, strLang[15], clWhite, TYPEFACE, ButtonFontSize, 30, THINBORDER);

end;

procedure TfrmOvMC.imgExitClick(Sender: TObject);
begin
     PlaySound('KLICK3.WAV', 1);
     Release;
end;

Procedure TfrmOvMC.DrawDifficultyButtons;
begin
     imgEasy.Visible := ShowDiffiButtons;
     imgHard.Visible := ShowDiffiButtons;
     If ShowDiffiButtons then
       If Easy then begin
          DrawButton(imgEasy, strLang[19], clWhite, TYPEFACE, ButtonFontSize, -1, NOBORDER);
          DrawButton(imgHard, strLang[20], $800000, TYPEFACE, ButtonFontSize, -1, NOBORDER);
       end else begin
          DrawButton(imgEasy, strLang[19], $800000, TYPEFACE, ButtonFontSize, -1, NOBORDER);
          DrawButton(imgHard, strLang[20], clWhite, TYPEFACE, ButtonFontSize, -1, NOBORDER);
       end;

end;

procedure TfrmOvMC.imgEasyClick(Sender: TObject);
begin
     Easy := True;
     DrawDifficultyButtons;
end;

procedure TfrmOvMC.imgHardClick(Sender: TObject);
begin
     Easy := False;
     DrawDifficultyButtons;
end;

procedure TfrmOvMC.FormKeyPress(Sender: TObject; var Key: Char);

begin
     If (Length(AltString[1]) = 1) and  (AnsiUpperCase(AltString[1][1]) = AnsiUpperCase(Key)) then
        imgSvar1Click(imgSvar1);
     If (Length(AltString[2]) = 1) and  (AnsiUpperCase(AltString[2][1]) = AnsiUpperCase(Key)) then
        imgSvar2Click(imgSvar2);
     If (Length(AltString[3]) = 1) and  (AnsiUpperCase(AltString[3][1]) = AnsiUpperCase(Key)) then
        imgSvar3Click(imgSvar3);
     If (Length(AltString[4]) = 1) and  (AnsiUpperCase(AltString[4][1]) = AnsiUpperCase(Key)) then
        imgSvar4Click(imgSvar4);
end;

procedure TfrmOvMC.imgHelpClick(Sender: TObject);
begin
    PlaySound('KLICK3.WAV', 1);
    Application.HelpContext(HelpContext);

end;

procedure TfrmOvMC.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If key=112 then begin
          ShowHelp(Handle);
     end;

     If (key=116) and (ExerciseType=HURMANGA) then begin
        CMaxNrOfPictures := 5;
     end;

     If (key=117) and (ExerciseType=HURMANGA) then begin
        CMaxNrOfPictures := 6;
     end;

     If (key=118) and (ExerciseType=HURMANGA) then begin
        CMaxNrOfPictures := 7;
     end;

     If (key=119) and (ExerciseType=HURMANGA) then begin
        CMaxNrOfPictures := 8;
     end;

     If (key=120) and (ExerciseType=HURMANGA) then begin
        CMaxNrOfPictures := 9;
     end;
end;

end.
