{

    Copyright 2004 Marianne Wartoft, marianne at wartoft dot nu
    http://www.wartoft.nu, http://www.aw.nu

    This file is part of Sebran.

    Sebran is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Sebran is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Sebran; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

}


unit Regn;
{The code for the rain exercises}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Generell, Message, StdCtrls, MPlayer;

type
  TfrmOvRegn = class(TForm)
    imgHelp: TImage;
    imgExit: TImage;
    imgPicture: TImage;
    imgRegn: TImage;
    Timer1: TTimer;
    shpRam: TShape;
    imgStart: TImage;
    imgScore: TImage;
    Shape1: TShape;
    shpScore: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure imgExitClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure imgStartClick(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure imgHelpClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    Procedure StartNewExercise;
    Procedure MoveDrop;
    Procedure NextDrop;
    procedure DrawScore;
public
    procedure Start(ExType: Integer);
  end;

  type TDrop = Record
       Pos: Integer;
       Text: String[10];
       Answer: String[1];
  end;

  const
       MAXPOS = 60;
  var
     NrOfDrops: Integer;
     Score : Integer;
     frmOvRegn: TfrmOvRegn;
     ExerciseType: Integer;
     MovingDrop: Integer;
     Drops: Array [1..40] of TDrop;
     DropWidth: Integer;
     THeight : Integer;
     intMaxScore: Integer;


implementation
uses
    Hmeny;

{$R *.DFM}


procedure TfrmOvRegn.Start(ExType: integer);
begin
     SetPalette(imgRegn);
     SetPalette(imgPicture);

     Case ExType of
        BOKSTAVSREGN: begin
             DrawButton(imgPicture, chr(Pics[6].ASCII), $FF3060, SYMBOLTYPEFACE, RefFontSize * 3, -1, NOBORDER);
             NrOfDrops := 10;
        end;
        MATTEREGN: begin
             DrawButton(imgPicture, chr(Pics[6].ASCII), $F09030, SYMBOLTYPEFACE, RefFontSize * 3, -1, NOBORDER);
             NrOfDrops := 7;
        end;
        ALFABETSREGN: begin
             DrawButton(imgPicture, chr(Pics[6].ASCII), $F09030, SYMBOLTYPEFACE, RefFontSize * 3, -1, NOBORDER);
             NrOfDrops := Length(strLang[33]);
        end;
     end;
     ExerciseType := ExType;
     Show;
     DropWidth := shpRam.Width div NrOfDrops;
     StartNewExercise;
end;

procedure TfrmOvRegn.StartNewExercise;
var
   i: Integer;
   Tal1, Tal2: Integer;
   X1,X2,Y1,Y2 : Integer;
   intPos: Integer;
begin
     PlaySong('DROPPAR.MID', 0, True);
     Randomize;
     Score := 0;
     DrawScore;
     imgRegn.Canvas.Brush.Color := clBlack;
     imgRegn.Canvas.FillRect(Rect(0,0 , imgRegn.Width, imgRegn.Height));
     Canvas.Brush.Color := clBlack;
     Canvas.FillRect(Rect(shpRam.Left, shpRam.Top, shpRam.left + shpRam.Width, shpRam.Top + shpRam.Height));
     For i:=1 to NrOfDrops do begin
         Drops[i].Pos := 0;
         Case ExerciseType of
         BOKSTAVSREGN: begin
            intPos := 1 + Trunc(Random * Length(strLang[33]));
            Drops[i].Text := CorrCase(strLang[33][intPos]);
            Drops[i].Answer := AnsiUppercase(Drops[i].Text);
         end;
         ALFABETSREGN: begin
            Drops[i].Text := CorrCase(strLang[33][i]);
            Drops[i].Answer := AnsiUppercase(Drops[i].Text);
         end;
         MATTEREGN: begin
            Tal1 := Trunc(Random * 5) + 1;
            Tal2 := Trunc(Random * 4) + 1;
            Drops[i].Text := Concat(IntToStr(Tal1), '+' , IntToStr(Tal2));
            Drops[i].Answer := IntToStr(Tal1 + Tal2);

         end;
         end;
     end;
     MovingDrop := 1;
     Timer1.Enabled := True;
end;

procedure TfrmOvRegn.DrawScore;
begin
   imgScore.Canvas.Brush.Color := clBlack;
   imgScore.Canvas.FillRect(Rect(0, 0, imgScore.Width, imgScore.Height));
   DrawCharCenter(imgScore.Width div 2, imgScore.Height div 2, imgScore,
                            IntToStr(Score),  clWhite, TYPEFACE, RefFontSize div 2);
   shpScore.Top := Trunc(height * ((intMaxScore-Score) / intMaxScore)  ) ;
   shpScore.Height := Height - shpScore.Top
end;


procedure TfrmOvRegn.FormCreate(Sender: TObject);
begin
     FixForm(Self);
end;

procedure TfrmOvRegn.FormShow(Sender: TObject);
begin
     DrawButton(imgHelp, strLang[14], clWhite, TYPEFACE, ButtonFontSize * 2, 30, THINBORDER);
     DrawButton(imgExit,strLang[15], clWhite, TYPEFACE, ButtonFontSize, 30, THINBORDER);
     if Length(strLang[17]) > 9 then
        DrawButton(imgStart, strLang[17], clWhite, TYPEFACE, ButtonFontSize-3, 30, THINBORDER)
     else
         DrawButton(imgStart, strLang[17], clWhite, TYPEFACE, ButtonFontSize, 30, THINBORDER);

     case intRainSpeed of
     2 : begin
          Timer1.Interval := 140;
          intMaxScore := 600;
          end;
     3 : begin
          Timer1.Interval := 240;
          intMaxScore := 300;
          end;

     else begin
          Timer1.Interval := 80;
          intMaxScore := 1000;
          end;
     end

end;

procedure TfrmOvRegn.imgExitClick(Sender: TObject);
begin
     PlaySound('KLICK3.WAV', 1);
     Release;
end;

Procedure TfrmOvRegn.MoveDrop;
var
   FontSize: Integer;
   FontName: String;
   X1, X2, Y11, Y12, Y21, Y22: Integer;
   Rectt: Hrgn;

begin
     if  Drops[MovingDrop].Pos = 0 then begin
        Case ExerciseType of
        BOKSTAVSREGN: begin
            FontSize := RefFontSize;
            FontName := TYPEFACE;
        end;
        MATTEREGN: begin
            FontSize := Trunc(RefFontSize / 1.5);
            FontName := TYPEFACE;
        end;
        ALFABETSREGN: begin
            if TYPEFACE = 'Arial' then begin
                FontSize := Trunc(RefFontSize / 2.5);

            end else begin
                FontSize := Trunc(RefFontSize / 2);
            end;
            FontName := TYPEFACE;
        end;
        End;
        imgRegn.Canvas.Font.Name := FontName;
        imgRegn.Canvas.Font.Size := FontSize;
        THeight := Trunc(imgRegn.Canvas.TextHeight('') * 1.5) ;
        DrawCharCenter(Trunc((MovingDrop - 0.5) * DropWidth),
                       Trunc(THeight / 1.5), imgRegn, Drops[MovingDrop].Text,
                       Pics[1 + Trunc(Random * NrOfPics)].Color, FontName, FontSize );
     end;

        X1 := Trunc((MovingDrop - 1) * DropWidth) + 1 ;
        X2 := Trunc((MovingDrop ) * DropWidth)  - 1;
        Y11 := 0 ;
        Y12 := THeight;

        Drops[MovingDrop].Pos := Drops[MovingDrop].Pos + 1;

        Y21 := Trunc(shpRam.Height * (Drops[MovingDrop].Pos / MAXPOS) - THeight);
        Y22 := Trunc(shpRam.Height  * (Drops[MovingDrop].Pos / MAXPOS));
        Canvas.CopyRect(Rect(X1 + shpRam.Left, Y21 + shpRam.Top, X2 + shpRam.Left, Y22 + shpRam.Top),
                        imgRegn.Canvas, Rect(X1, Y11, X2, Y12));
     if Drops[MovingDrop].Pos = MAXPOS then begin
        PlaySound('Dropp3.WAV', 1);
        NextDrop;
     end;
end;

procedure TfrmOvRegn.Timer1Timer(Sender: TObject);
begin
     MoveDrop;
end;

procedure TfrmOvRegn.FormKeyPress(Sender: TObject; var Key: Char);
var
   TempString: String[1];
begin
     If MovingDrop <= NrOfDrops then begin
        TempString := Key;
        TempString := AnsiUpperCase(TempString);
        If TempString = Drops[MovingDrop].Answer then begin
           If ExerciseType = MATTEREGN then begin
              Drops[MovingDrop].Text := Drops[MovingDrop].Answer;
              MoveDrop;
           end;
           NextDrop;
        end else begin
            Score := Score - 10;
            DrawScore;
        end;
     end;
end;

procedure TfrmOvRegn.NextDrop;
begin
     PlaySound('DRIPDROP.WAV', 1);
     If Drops[MovingDrop].Pos <> MAXPOS then
        Score :=  Score + Trunc(10 / NrOfDrops * 100 * (MAXPOS - Drops[MovingDrop].Pos) / MAXPOS * intMaxScore / 1000);
     DrawScore;
     MovingDrop := MovingDrop + 1;
     If MovingDrop > NrOfDrops then begin
        Timer1.Enabled := False;
        StopSong;
     end;
end;

procedure TfrmOvRegn.imgStartClick(Sender: TObject);
begin
     PlaySound('KLICK3.WAV', 1);
     StartNewExercise;
end;

procedure TfrmOvRegn.FormClick(Sender: TObject);
begin
    Application.HelpContext(HelpContext);

end;

procedure TfrmOvRegn.imgHelpClick(Sender: TObject);
begin
    PlaySound('KLICK3.WAV', 1);
    Application.HelpContext(HelpContext);

end;

procedure TfrmOvRegn.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If key=112 then begin
          ShowHelp(Handle);
     end;
end;

end.

