{

    Copyright 2004 Marianne Wartoft, marianne at wartoft dot nu
    http://www.wartoft.nu, http://www.aw.nu

    This file is part of Sebran.

    Sebran is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Sebran is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Sebran; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

}


unit Message;
{ This is the code for the message window, which displays a
  small message box on-screen.}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Generell;

type
  TfrmMessage = class(TForm)
    imgKnapp1: TImage;
    imgKnapp2: TImage;
    lblText: TLabel;
    Shape1: TShape;
    procedure imgKnapp1Click(Sender: TObject);
    procedure imgKnapp2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMessage: TfrmMessage;

Function ShowMessage(Text: String; Knapp1, Knapp2: String): Integer;


implementation

Function ShowMessage(Text: String; Knapp1, Knapp2: String): Integer;
begin
     frmMessage.Color := clBlack;
     frmMessage.lblText.Caption := Text;
     DrawButton(frmMessage.imgKnapp1, Knapp1, clWhite, TYPEFACE, 16 , 30, THINBORDER);
     DrawButton(frmMessage.imgKnapp2, Knapp2, clWhite, TYPEFACE, 16 , 30, THINBORDER);
     Result := frmMessage.ShowModal;
end;

{$R *.DFM}

procedure TfrmMessage.imgKnapp1Click(Sender: TObject);
begin
     ModalResult := 1;
end;

procedure TfrmMessage.imgKnapp2Click(Sender: TObject);
begin
     ModalResult := 2;
end;

end.
